/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

public final class OSUtils {
    private static final String OS = System.getProperty("os.name");

    public static boolean isWindows() {
        return OS.startsWith("Windows");
    }

    public static boolean isLinux() {
        return OS.startsWith("Linux");
    }

    public static boolean isMac() {
        return OS.startsWith("Mac");
    }

    public static boolean isBSD() {
        return OS.startsWith("FreeBSD") || OS.startsWith("NetBSD") || OS.startsWith("OpenBSD");
    }

    public static boolean isUnixFamily() {
        return OSUtils.isLinux() || OSUtils.isMac() || OSUtils.isBSD();
    }

    public static String getUserDataDirectory() {
        String userDataDirectory = null;
        if (OSUtils.isWindows()) {
            userDataDirectory = System.getProperty("user.dir");
        } else if (OSUtils.isMac()) {
            userDataDirectory = System.getProperty("user.home") + "/Library/Application Support/" + "openMSX Launcher";
        } else if (OSUtils.isLinux() || OSUtils.isBSD()) {
            userDataDirectory = System.getProperty("user.home") + "/" + "openMSX Launcher";
        }
        return userDataDirectory;
    }
}

